/*
 * Decompiled with CFR 0.152.
 */
package cds.vizier;

import cds.aladin.Glu;
import cds.aladin.MyInputStream;
import cds.tools.CDSConstants;
import cds.tools.CDSMethods;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class VizieRQuery
implements XMLConsumer,
CDSConstants {
    static final int KEYWORDS = 0;
    static final int SURVEYS = 1;
    static final int ARCHIVES = 2;
    static final int CATALOGS = 3;
    static final int TD = 4;
    static final int SURVEYMAXCOL = 3;
    static final int ARCHIVEMAXCOL = 3;
    private int section;
    private String currentCat = null;
    private String currentWaveLength = null;
    private String currentDensity = null;
    private String currentDesc = null;
    private String metaError;
    private Vector vKey;
    private boolean inCSV;
    private boolean inTD;
    private boolean inDesc;
    private String headlines;
    private String recsep;
    private String colsep;
    private int column = 0;
    private static Vector vSurveys = null;
    private static Vector vArchives = null;
    private static Hashtable hKey = null;
    private static Vector nameKey = null;
    private StringBuffer currentSurvey = new StringBuffer();
    private StringBuffer currentArchive = new StringBuffer();
    private MyInputStream vizierStream = null;
    private int currentFormat = 0;
    private Vector resultat = null;
    protected Glu glu = null;

    public static void resetKeywords() {
        nameKey = null;
        vArchives = null;
        vSurveys = null;
        hKey = null;
    }

    public boolean metaDataQuery() {
        if (vSurveys != null) {
            return true;
        }
        XMLParser xmlParser = new XMLParser(this);
        this.metaError = null;
        this.section = -1;
        vSurveys = new Vector(30);
        vArchives = new Vector(30);
        hKey = new Hashtable();
        nameKey = new Vector();
        this.vKey = null;
        this.inCSV = false;
        URL url = null;
        try {
            url = this.glu != null ? this.glu.getURL("VizieR.Meta", "", false, false) : new URL("http://vizier.u-strasbg.fr/viz-bin/nph-metaladin");
            InputStream instream = this.glu.aladin.getCache().get(url);
            MyInputStream dis = new MyInputStream(instream);
            boolean res = xmlParser.parse(dis);
            return res && this.metaError == null;
        }
        catch (Exception e) {
            this.metaError = "" + e;
            System.err.println("metaDataQuery : " + e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean catalogsDataQuery(String param, int outputMode, Vector resultat) {
        XMLParser xmlParser = new XMLParser(this);
        this.metaError = null;
        this.section = 3;
        this.inDesc = false;
        this.currentCat = null;
        this.currentWaveLength = null;
        this.currentDensity = null;
        this.currentDesc = null;
        this.resultat = resultat;
        URL url = null;
        try {
            url = this.glu != null ? this.glu.getURL("VizieR.MetaCat", param, true) : new URL("http://vizier.u-strasbg.fr/cgi-bin/votable?-meta&" + param);
            if (outputMode == 1) {
                this.resultat.clear();
                MyInputStream dis = new MyInputStream(url.openStream());
                boolean res = xmlParser.parse(dis);
                return res;
            }
            this.vizierStream = new MyInputStream(url.openStream());
            return this.vizierStream != null;
        }
        catch (Exception e) {
            this.metaError = "" + e;
            System.err.println("catalogsDataQuery : " + e);
            return false;
        }
    }

    @Override
    public void startElement(String name, Hashtable atts) {
        if (name.equals("VOTABLE")) {
            this.currentFormat = 1;
        }
        if (name.equals("ASTRO")) {
            this.currentFormat = 0;
        }
        if (this.section == 3) {
            String attribute;
            if (name.equals("DESCRIPTION")) {
                this.inDesc = true;
            } else if (name.equals("RESOURCE")) {
                if (this.currentFormat == 1) {
                    this.currentCat = (String)atts.get("name");
                } else if (this.currentFormat == 0) {
                    this.currentCat = (String)atts.get("ID");
                }
            } else if (name.equals("INFO") && (attribute = (String)atts.get("name")) != null) {
                if (attribute.equals("-kw.Wavelength")) {
                    this.currentWaveLength = (String)atts.get("value");
                }
                if (attribute.equals("-density")) {
                    this.currentDensity = (String)atts.get("value");
                }
            }
            return;
        }
        if (name.equals("RESOURCE")) {
            String ID = (String)atts.get("ID");
            if (ID != null && ID.equals("VizieR")) {
                this.section = 0;
            }
        } else if (name.equals("TABLE")) {
            String ID = (String)atts.get("ID");
            if (ID != null && ID.equals("AladinSurveys")) {
                this.section = 1;
            } else if (ID != null && ID.equals("AladinArchives")) {
                this.section = 2;
            }
        } else if (this.section == 0 && name.equals("PARAM") && this.currentFormat == 1) {
            String section = (String)atts.get("name");
            if (section.startsWith("-kw.")) {
                this.vKey = new Vector(30);
                nameKey.addElement(section);
                hKey.put(section, this.vKey);
            }
        } else if (this.section == 0 && name.equals("FIELD") && this.currentFormat == 0) {
            String section = (String)atts.get("name");
            if (section.startsWith("-kw.")) {
                this.vKey = new Vector(30);
                nameKey.addElement(section);
                hKey.put(section, this.vKey);
            }
        } else if (this.vKey != null && name.equals("OPTION")) {
            String s = (String)atts.get("value");
            if (s != null) {
                this.vKey.addElement(s);
            }
        } else if ((this.section == 1 || this.section == 2) && name.equals("CSV")) {
            this.inCSV = true;
            this.headlines = (String)atts.get("headlines");
            this.recsep = (String)atts.get("recsep");
            this.colsep = (String)atts.get("colsep");
        } else if ((this.section == 1 || this.section == 2) && name.equals("TD")) {
            this.inTD = true;
            ++this.column;
        } else if (name.equals("TR")) {
            this.currentSurvey = new StringBuffer();
            this.currentArchive = new StringBuffer();
            this.column = 0;
        }
    }

    @Override
    public void endElement(String name) {
        if (this.vKey != null && name.equals("FIELD")) {
            this.vKey = null;
        } else if (this.section == 3 && name.equals("DESCRIPTION")) {
            this.inDesc = false;
        } else if (name.equals("CSV")) {
            this.inCSV = false;
        } else if (name.equals("RESOURCE") && this.currentCat != null) {
            this.addItem(this.currentCat + "\t" + this.currentWaveLength + "\t" + this.currentDensity + "\t" + this.currentDesc);
            this.currentCat = null;
            this.currentDesc = "";
            this.currentDensity = "";
            this.currentWaveLength = "";
        }
    }

    private int getField(StringBuffer rec, char[] ch, int cur, int end, char recsep, char colsep) {
        int start = cur;
        while (cur < end && ch[cur] != colsep && ch[cur] != recsep) {
            ++cur;
        }
        String s = new String(ch, start, cur - start).trim();
        if (s.length() != 0) {
            if (rec.length() != 0) {
                rec.append("\t");
            }
            rec.append(s);
        }
        return ch[cur] == colsep ? cur + 1 : cur;
    }

    private int getRec(StringBuffer rec, char[] ch, int cur, int end, char recsep, char colsep) {
        while (cur < end && ch[cur] != recsep) {
            cur = this.getField(rec, ch, cur, end, recsep, colsep);
        }
        return cur;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        char rs = '\n';
        char cs = '\t';
        int cur = start;
        int end = start + length;
        int n = 0;
        if (this.section == 3) {
            if (this.inDesc) {
                this.currentDesc = new String(ch, start, length);
            }
            return;
        }
        if (this.inCSV) {
            StringBuffer rec;
            if (this.recsep != null) {
                rs = this.recsep.charAt(0);
            }
            if (this.colsep != null) {
                cs = this.colsep.charAt(0);
            }
            int h = this.headlines == null ? 0 : Integer.parseInt(this.headlines);
            n = 0;
            for (n = 0; cur < end && n < h; ++cur, ++n) {
                rec = new StringBuffer();
                cur = this.getRec(rec, ch, cur, end, rs, cs);
            }
            while (cur < end) {
                rec = new StringBuffer();
                cur = this.getRec(rec, ch, cur, end, rs, cs);
                switch (this.section) {
                    case 1: {
                        vSurveys.addElement(rec.toString());
                        break;
                    }
                    case 2: {
                        vArchives.addElement(rec.toString());
                    }
                }
                ++cur;
            }
            return;
        }
        if (this.inTD) {
            String data = new String(ch, start, length);
            switch (this.section) {
                case 1: {
                    if (this.column < 3) {
                        if (this.column != 1) {
                            this.currentSurvey.append("\t");
                        }
                        this.currentSurvey.append(data);
                    } else {
                        this.currentSurvey.append("\t");
                        this.currentSurvey.append(data);
                        vSurveys.addElement(this.currentSurvey.toString());
                    }
                    this.inTD = false;
                    break;
                }
                case 2: {
                    if (this.column < 3) {
                        if (this.column != 1) {
                            this.currentArchive.append("\t");
                        }
                        this.currentArchive.append(data);
                    } else {
                        this.currentArchive.append("\t");
                        this.currentArchive.append(data);
                        vArchives.addElement(this.currentArchive.toString());
                    }
                    this.inTD = false;
                }
            }
            return;
        }
    }

    public String getMetaError() {
        return this.metaError;
    }

    public Vector getvArchives() {
        return vArchives;
    }

    public Vector getvSurveys() {
        return vSurveys;
    }

    public Hashtable gethKey() {
        return hKey;
    }

    public Vector getNameKey() {
        return nameKey;
    }

    public void setGLU(Glu glu) {
        this.glu = glu;
    }

    protected void addItem(String s) {
        if (this.resultat != null) {
            this.resultat.addElement(s);
        }
    }

    public MyInputStream getResultStream() {
        return this.vizierStream;
    }

    public boolean submit(String target, String radius, String unit, String coordinate, String author, String extra, int mode, Vector resultat) {
        StringBuffer param = new StringBuffer();
        if (target == null) {
            param.append("-pos");
        } else {
            CDSMethods.append(param, "-c", target);
            if (radius != null) {
                StringTokenizer radiusToken = new StringTokenizer(radius, " ");
                if (radiusToken.hasMoreTokens()) {
                    CDSMethods.append(param, "-c.r", radiusToken.nextToken());
                }
                if (radiusToken.hasMoreTokens()) {
                    String token = radiusToken.nextToken();
                    if (token.compareTo("deg") == 0 || token.compareTo("degree") == 0) {
                        CDSMethods.append(param, "-c.u", "degree");
                    } else {
                        CDSMethods.append(param, "-c.u", token);
                    }
                } else {
                    CDSMethods.append(param, "-c.u", "arcmin");
                }
            }
        }
        if (coordinate != null && coordinate.compareTo("") != 0) {
            CDSMethods.append(param, "-c.eq", coordinate);
        }
        if (author != null && author.compareTo("") != 0) {
            CDSMethods.append(param, "-words", author);
        }
        if (extra != null) {
            param.append('&' + extra);
        }
        return this.callVizieR(param.toString(), mode, resultat);
    }

    public boolean submit(String target, String radius, String unit, String tauthor, String extra, int mode, Vector resultat) {
        return this.submit(target, radius, unit, null, tauthor, extra, mode, resultat);
    }

    protected boolean callVizieR(String param, int mode, Vector resultat) {
        if (param == null) {
            System.out.println("param null");
        }
        if (resultat == null) {
            System.out.println("resultat null");
        }
        boolean res = this.catalogsDataQuery(param, mode, resultat);
        if (mode == 1) {
            return res && resultat != null && resultat.size() > 0;
        }
        return res;
    }

    public void query() {
    }
}

